## @knitr load-library
library(xxm) 
data(lranslp.xxm,package="xxm")

## @knitr define-variables
levels <- c("l1", "l2")
id1 <-  levels
ys1  <- c("y1", "y2", "y3", "y4")
xs1 <- c("x")
l1vars <- c(levels,ys1,xs1)
es1 <- c("fw")
id2 <-  "l2" 
l2vars <- c("l2")
es2 <- c("int","slp")

## @knitr construct-R-matrices
########################## Student Model Matrices ################
#Student: factor-loading matrix: Pattern and value
ly1_pat <- matrix(1,4,1)
ly1_val <-  matrix(.1, 4,1) 
#Student: factor-covariance matrix: Pattern and value
ps1_pat <- diag(0,1)
ps1_val <- diag(1,1)
#Student: observed residual-covariance matrix: Pattern and value
th1_pat <- diag(1,4)
th1_val <- diag(1,4)
###################### School Model Matrices ####################
#School: factor-covariance matrix: Pattern and value
ps2_pat <- matrix(1,2,2)
ps2_val <- diag(.2,2)
#School: means: Pattern and value
al2_pat <- matrix(1,2,1)
al2_val <- matrix(c(1,.2),2,1)
###################### School - > Student matrices ############
#School->Student: Beta (latent-on-latent regression) matrix: Pattern, value AND label
be12_pat <- matrix(c(0,0), 1, 2)
be12_val <- matrix(c(1,0), 1, 2)
be12_label  <- matrix(c("one","l1.x"), 1, 2)

## @knitr xxmModel 
xm <- xxmModel(levels = levels)

## @knitr xxmSubmodel
### Submodel: Student
xm <- xxmSubmodel(model = xm, level = "l1", parents = "l2",
                  ys = ys1, xs = xs1, etas = es1, data = l1)

### Submodel: School
xm <- xxmSubmodel(model = xm, level = "l2",
                  parents =, ys =, xs =, etas = es2, data = l2) 

## @knitr xxmWithinMatrix
#l1 within matrices (lambda, psi, and theta)
xm <- xxmWithinMatrix(xm,"l1","lambda", ly1_pat, ly1_val,,)
xm <- xxmWithinMatrix(xm,"l1","psi", ps1_pat, ps1_val,,)
xm <- xxmWithinMatrix(xm,"l1","theta", th1_pat, th1_val,,)
#l2 within matrices (psi and alpha)
xm <- xxmWithinMatrix(xm,"l2","psi", ps2_pat, ps2_val,,)
xm <- xxmWithinMatrix(xm,"l2","alpha", al2_pat, al2_val,,)  

## @knitr xxmBetweenMatrix
xm <- xxmBetweenMatrix(xm,"l2","l1","beta", be12_pat, be12_val,be12_label,)

## @knitr xxmRun 
xx <-xxmRun(xm)

## @knitr xxmCI
xm <- xxmCI(xm)

## @knitr xxmSummary
s <- xxmSummary(xm)
s

## @knitr xxmFree
xxmFree(xm) 

#rm(list=ls())
#detach("package:xxm", unload=TRUE)
