library(xxm) 
data(ex98.xxm,package="xxm")
#examine datafiles
head(ex98.l1)
head(ex98.l2)
#defining levels, variables, etc.
levels <- c("l1", "l2")
id1 <-  levels
ys1  <- c("y1", "y2", "y3", "y4")
xs1 <- c("x1", "x2")
l1vars <- c(levels,ys1,xs1)
es1 <- c("fw")
id2 <-  "l2" 
l2vars <- c("l2","w")
xs2 <- c("w")
es2 <- c("fb","s1","s2")
################################################################## 
########################## l1 MODEL MATRICES ################
#Student: factor-loading matrix: Pattern of free parameters
ly1_pat <- matrix(c(0,1,1,1),4,1)
#Student: factor-loading matrix: start values
ly1_val <-  matrix(c(1,0.77719,1,1), 4,1) 
#Student: factor-loading matrix: labels (optional)
ly1_lab<- matrix(c("a","b","c","d"),4,1) 
#Student: factor-covariance matrix: Pattern of free parameters
ps1_pat <- diag(1,1)
#Student: factor-covariance matrix: Starting values
ps1_val <- diag(.001,1)
#Student: observed residual-covariance matrix: Pattern of free parameters
th1_pat <- diag(1,4)
#Student: observed residual-covariance matrix: start values
th1_val <- diag(1,4)
#Student: Observed intercepts: Pattern of free parameters
nu1_pat <- matrix(1,4,1)
#Student: Observed intercepts: start values
nu1_val <- matrix(0,4,1)
################################################################## 
###################### School model matrices ############
#ps: latent factor covariance
ps2_pat <- diag(c(1,1,1),3)
ps2_val <- diag(c(.001,.1,.1),3)
#gamma: eta on x
ga2_pat <- matrix(1,3,1)
ga2_val <- matrix(.1,3,1)
#alpha: Intercepts
al2_pat <- matrix(c(0,1,1),3,1)
al2_val <- matrix(0,3,1)
################################################################## 
###################### School - > Student matrices ############
#across level factor-loading matrix 
ly12_pat <- matrix(c(0,0,0,
	1,0,0,	
	1,0,0,
	1,0,0),4,3,byrow=TRUE)
ly12_val<- matrix(c(1,0,0,
	1,0,0,	
	1,0,0,
	1,0,0),4,3,byrow=TRUE)
ly12_lab<- matrix(c( "e","0","0",
	"f","0","0",	
	"g","0","0",
	"h","0","0"),4,3,byrow=TRUE)
#across level latent-regression matrix 
#Note the use of definition variables for defining level-2 random-slopes
be12_pat <- matrix(c(0,0,0), 1, 3)
be12_val <- matrix(c(0,0,0), 1, 3)
be12_label  <- matrix(c("be12","l1.x1", "l1.x2"), 1, 3)
#xxm Script
xm <- xxmModel(levels)
xm <- xxmSubmodel(model = xm, 		level = "l1",  		parents = "l2",
		ys = ys1, 		xs = xs1, 		etas = es1, 	data = ex98.l1)
xm <- xxmSubmodel(model = xm, 		level = "l2", 		parents =,
		ys =,		xs = xs2, 	etas = es2, 	data = ex98.l2) 
##################################################################
#l1 within matrices (lambda, psi, theta and nu)
xm <- xxmWithinMatrix(xm,"l1","lambda", ly1_pat, ly1_val,ly1_lab,)
xm <- xxmWithinMatrix(xm,"l1","psi", ps1_pat, ps1_val,,)
xm <- xxmWithinMatrix(xm,"l1","theta", th1_pat, th1_val,,)
xm <- xxmWithinMatrix(xm,"l1","nu", nu1_pat, nu1_val,,)
#l2 within matrices (psi)
xm <- xxmWithinMatrix(xm,"l2","psi", ps2_pat, ps2_val,,)
xm <- xxmWithinMatrix(xm,"l2","gamma", ga2_pat, ga2_val,,)
xm <- xxmWithinMatrix(xm,"l2","alpha", al2_pat, al2_val,,)  
##l2->l1 lambda matrix 
xm <- xxmBetweenMatrix(xm,"l2","l1","beta", be12_pat, be12_val,be12_label,)
xm <- xxmBetweenMatrix(xm,"l2","l1","lambda", ly12_pat, ly12_val,,)
xx <-xxmRun(xm) 
xm <- xxmCI(xm)
est <- xxmGet(xm,"estimates")
lik <- xxmGet(xm,"fit")
est
lik
xxmFree(xm) 
rm(list=ls())
detach("package:xxm", unload=TRUE)
