library(xxm) 
data(ex98.xxm,package="xxm") 
#level info
levels <- c("l1", "l2")
#level 1 variables etc.
id1 <-  levels
ys1  <- c("y1", "y2", "y3", "y4")
xs1 <- c("x1", "x2")
l1vars <- c(levels,ys1,xs1)
es1 <- c("fw")
#level 2 variables etc.
id2 <-  "l2" 
l2vars <- c("l2","w")
xs2 <- c("w")
es2 <- c("fb","s1","s2")
################################################################## 
########################## l1 MODEL MATRICES ################
#Student: factor-loading matrix: Pattern of free parameters
ly1_pat <- matrix(c(1,1,1,1),4,1)
#ly1_val <-  matrix(c(1,.942,.845,.701), 4,1) 
ly1_val <-  matrix(c(.1,.1,.1,.1), 4,1) 
#Student: factor-covariance matrix: Pattern of free parameters
ps1_pat <- diag(0,1)
ps1_val <- diag(1,1)
#Student: observed residual-covariance matrix: Pattern of free parameters
th1_pat <- diag(1,4)
th1_val <- diag(c(2.11234,2.4321,1.0917,2.1154),4)
################################################################## 
###################### School model matrices ############
#School level covariance matrix 
ps2_pat <- diag(1, 3) 
ps2_val <- diag(c(.01,.1,.01),3) 
#School level latent on observed regression matrix 
ga2_pat <- matrix(1,3,1)
ga2_val <- matrix(c(.1,.1,.1),3,1)
#School level latent intercepts
al2_pat <- matrix(c(1,1,1),3,1)
al2_val <- matrix(c(0,0,0),3,1)
################################################################## 
###################### School - > Student matrices ############
#school->student latent on latent regression matrix
#note the use of defintion-variables in the label matrix
be12_pat <- matrix(c(0,0,0), 1, 3)
be12_val <- matrix(c(1,0,0), 1, 3)
be12_label  <- matrix(c("be12","l1.x1", "l1.x2"), 1, 3)
#xxm model specification
#Step 1: Create model and define level names
xm <- xxmModel(levels=levels) 
#Step 2: Create submodels for each level declared in xxmModel()
xm <- xxmSubmodel(model = xm, level = "l1", parents = "l2",
		ys = ys1,xs = xs1, etas = es1,data = ex98.l1)
xm <- xxmSubmodel(model = xm,level = "l2",parents=,ys=,xs=xs2,etas = es2, data = ex98.l2) 
#Step 3A: Add within-matrices to submodels
#l1 within matrices (lambda, psi and theta)
xm <- xxmWithinMatrix(xm,"l1","lambda", ly1_pat, ly1_val,,)
xm <- xxmWithinMatrix(xm,"l1","psi", ps1_pat, ps1_val,,)
xm <- xxmWithinMatrix(xm,"l1","theta", th1_pat, th1_val,,)
#l2 within matrices (psi, gamma and alpha)
xm <- xxmWithinMatrix(xm,"l2","psi", ps2_pat, ps2_val,,)
xm <- xxmWithinMatrix(xm,"l2","gamma", ga2_pat, ga2_val,,)
xm <- xxmWithinMatrix(xm,"l2","alpha", al2_pat, al2_val,,)  
#Step 3B: Add between-matrices connecting submodels
##l2->l1 lambda matrix 
xm <- xxmBetweenMatrix(xm,"l2","l1","beta", be12_pat, be12_val,be12_label,)
#Step 4: Compute
xx <-xxmRun(xm) 
xm <- xxmCI(xm)
est <- xxmGet(xm,"estimates")
lik <- xxmGet(xm,"fit")
est
lik
#Step 4: Clean-up
xxmFree(xm) 
rm(list=ls())
detach("package:xxm", unload=TRUE)
