# The following line makes the two dataframes available to R:
library(xxm)
data(pcwa.xxm, package="xxm")
str(pcwa.teacher)
str(pcwa.student) 
##########################
##########################
#   Model 1: simple random intercept
# 1.1 Model setup
pcwa1 <- xxmModel(c("student","teacher"))
pcwa1 <- xxmSubmodel(model = pcwa1, level = "student",
   parents = "teacher", ys = "pc", xs = ,
   etas  = , data = pcwa.student)

pcwa1 <- xxmSubmodel(model = pcwa1, level = "teacher",
   parents = , ys = , xs = , etas = c("int"), data = pcwa.teacher)
 
# 1.2  Matrix specification
alpha_pattern <- matrix(1, 1,1)
alpha_value <- (matrix(443.15, 1,1))

psi_pattern <- matrix(1, 1,1)
psi_value <- (matrix(10., 1,1))

lambda_pattern <- matrix(0, 1,1)
lambda_value <- (matrix(1, 1,1))

theta_pattern <- matrix(1, 1,1)
theta_value <- (matrix(400., 1,1))

#Level 1: Student model
pcwa1 <- xxmWithinMatrix(model=pcwa1, 
                         level="student",
                         type ="theta",
                         pattern=theta_pattern, 
                         value=theta_value,,)

pcwa1 <- xxmWithinMatrix(model = pcwa1, 
                         level = "teacher",
                         type = "alpha", 
                         pattern = alpha_pattern, 
                         value = alpha_value,,)

pcwa1 <- xxmWithinMatrix(model = pcwa1, 
                         level = "teacher",
                         type = "psi", 
                         pattern = psi_pattern, 
                         value = psi_value,,)

pcwa1 <- xxmBetweenMatrix(model = pcwa1, 
                          parent = "teacher",
                          child = "student", 
                          type = "lambda", 
                          pattern = lambda_pattern, 
                          value = lambda_value,,)

# 1.3 Run model
pcwa1 <-xxmRun(pcwa1)
pcwa1 <- xxmCI(pcwa1)
est <- xxmGet(pcwa1,"estimates")
lik <- xxmGet(pcwa1,"fit")
est
lik
xxmFree(pcwa1)
rm(list=ls())
detach("package:xxm", unload=TRUE)
