## @knitr load-library
library(xxm)
data(reisby.long.xxm, package="xxm")

## @knitr construct-R-matrices
#Within-level matrices
#Response: level-1 matrices
#Theta : observed residual covariance
th1_pat <-matrix(1,1,1)
th1_val <-matrix(20,1,1)

#Subject: level-2 matrices
#Psi : Laent growth factor covariance
ps2_pat <- matrix(1,2,2)
ps2_val <- diag(.1,2)
#Psi :: Laent growth factor means
al2_pat <- matrix(1,2,1)
al2_val <- matrix(c(25 ,-1),2,1)

#Across-level matrices
#Subject to respons (level-2 to level-1)
#factor loading matrix
ly12_pat <-matrix(0,1,2)
ly12_val <-matrix(c(1,0),1,2)
ly12_label <-matrix(c("one","response.week"),1,2)

## @knitr xxmModel
lgc <- xxmModel(c("response", "subject")) 

## @knitr xxmSubmodel
lgc <- xxmSubmodel(model = lgc, level = "response", parents = "subject", 
                     ys = "depression", xs = "week", etas =, data = response)
lgc <- xxmSubmodel(model = lgc, level = "subject", parents =, ys =, xs =, 
                     etas = c("intercept","week_slope"), data = subject)
## @knitr xxmWithinMatrix
lgc <- xxmWithinMatrix(lgc,"response","theta", th1_pat, th1_val)
lgc <- xxmWithinMatrix(lgc,"subject","psi", ps2_pat, ps2_val)
lgc <- xxmWithinMatrix(lgc,"subject","alpha", al2_pat, al2_val)
## @knitr xxmBetweenMatrix
lgc <- xxmBetweenMatrix(lgc, "subject", "response","lambda", 
                          ly12_pat, ly12_val,ly12_label)
## @knitr xxmRun
lgc <- xxmRun(lgc)
## @knitr xxmCI
lgc <- xxmCI(lgc)
## @knitr xxmSummary
xxmSummary(lgc)
## @knitr xxmFree
lgc <- xxmFree(lgc)
rm(list=ls())
