## @knitr load-library
library(xxm) 
data(hcfa.xxm,package="xxm")

## @knitr define-variables
levels <- c("student", "teacher", "school")
#Level 1 variables:
id1 <-  levels
ys1  <- c("y1", "y2", "y3")
etas1 <- c("A1")
l1parents <-c("teacher","school")
#Level 2 variables:
id2 <-  c("teacher","school")
etas2 <- c("A2")
#Level 3 variables:
id3 <-  c("school")
ys3 <- c("q1","q2","q3")
etas2 <- c("A3","Q")

## @knitr construct-R-matrices
## STUDENT MODEL MATRICES (Within-model matrices)
## Student: factor-loading matrix 
ly1_pat <-  matrix(0,3,1)
ly1_val <-  matrix(1,3,1) 
## Student: factor-covariance matrix 
ps1_pat <- matrix(1,1,1)
ps1_val <- matrix(0.1,1,1)
## Student: observed residual-covariance matrix   
th1_pat <- diag(1,3)
th1_val <- diag(2,3)
## Student "grand-means" NU 
nu1_pat <- matrix(1,3,1)
nu1_val <- matrix(0,3,1)
##
## TEACHER MODEL MATRICES (Within-model matrices) 
## Teacher: Latent covariance matrix
ps2_pat <- matrix(1,1,1)
ps2_val <- matrix(0.1,1,1)
##
## SCHOOL MODEL MATRICES (Within-model matrices) 
## School: factor-loading matrix
ly3_pat <- matrix(0,3,2)
ly3_val <- matrix(c(0,0,0, 1,1,1),3,2)
## School: factor-covariance matrix
ps3_pat <- matrix(c(1,0,0,1),2,2)
ps3_val <- matrix(c(0.1,0,0,.1),2,2)
## School: Observed covariance matrix
th3_pat <- diag(1,3)
th3_val <- diag(2,3)
## School: Observed intercepts
nu3_pat <- matrix(1,3,1)
nu3_val <- matrix(c(.1,.1,.1),3,1)
## School: Latent Regression
be3_pat <- matrix(c(0,0,1,0),2,2)
be3_val <- matrix(c(0,0,.01,0),2,2)
##
## TEACHER -> STUDENT (Across-model matrices)
## teacher - > Student: factor loading matrix 
ly21_pat <- matrix(0,3,1) 
ly21_val <- matrix(1,3,1)
## SCHOOL -> STUDENT (Across-model matrices)
## school - > Student: factor loading matrix 
ly31_pat <- matrix(0,3,2) 
ly31_val <- matrix(c(1,1,1,0,0,0),3,2) 

## @knitr xxmModel
xm <- xxmModel(levels = c("student", "teacher", "school"))

## @knitr xxmSubmodel
### Submodel: Student
xm <- xxmSubmodel(model = xm, level = "student", parents = l1parents, 
                  ys = ys1, xs =, etas=etas1, data = hcfa.student)
### Submodel: Teacher
xm <- xxmSubmodel(model = xm, level="teacher", parents =, ys =, xs =, 
                  etas = c("A2"), data = hcfa.teacher)
### Submodel: School
xm <- xxmSubmodel(model = xm,level = "school",parents =, 
                  ys = c("q1","q2","q3"), xs =, etas = c("A3", "Q3"), data = hcfa.school)

## @knitr xxmWithinMatrix
## Student within matrices (lambda, psi, theta and nu)
xm <- xxmWithinMatrix(xm,"student","lambda", ly1_pat, ly1_val)
xm <- xxmWithinMatrix(xm,"student","psi", ps1_pat, ps1_val)
xm <- xxmWithinMatrix(xm,"student","theta", th1_pat, th1_val)
xm <- xxmWithinMatrix(xm,"student","nu", nu1_pat, nu1_val) 
## Teacher within matrices (psi)
xm <- xxmWithinMatrix(xm,"teacher","psi", ps2_pat, ps2_val)
## School within matrices (psi)
xm <- xxmWithinMatrix(xm,"school","lambda", ly3_pat, ly3_val)
xm <- xxmWithinMatrix(xm,"school","psi", ps3_pat, ps3_val)
xm <- xxmWithinMatrix(xm,"school","theta", th3_pat, th3_val)
xm <- xxmWithinMatrix(xm,"school","nu", nu3_pat, nu3_val) 
xm <- xxmWithinMatrix(xm,"school","beta", be3_pat, be3_val) 

## @knitr xxmBetweenMatrix
## Teacher->Student lambda matrix 
xm <- xxmBetweenMatrix(xm,"teacher","student","lambda", ly21_pat, ly21_val)
## School->Student lambda matrix 
xm <- xxmBetweenMatrix(xm,"school","student","lambda", ly31_pat, ly31_val)
## @knitr xxmRun
xm <-xxmRun(xm)
## @knitr xxmCI
xm <- xxmCI(xm)
## @knitr xxmSummary
s <- xxmSummary(xm)
s
## @knitr xxmFree
xxmFree(xm)
rm(list=ls())
