

[su_tabs] [su_tab title="xxM"]

## Load xxM and data



<a name="construct-R-matrices"></a>
## Construct R-matrices  

For each parameter matrix, construct three related matrices:  

1. **pattern** matrix: A matrix indicating free or fixed parameters.
2. **value** matrix: with start or fixed values for corresponding parameters.
3. **label** matrix: with user friendly label for each parameter. **label** matrix is optional. 




## Construct main model object  

`xxmModel()` is used to declare level names. The function returns a model object that is passed as a parameter to subsequent stattements.




## Add submodels to the model objects

For each declared level `xxmSubmodel()` is invoked to add corresponding submodel to the model object. The function adds three pieces of information:
1. **parents** declares a list of parents of the current level.
2. **variables** declares names of observed dependent (**ys**), observed independent (**xs**) and latent variables (**etas**) for the level.
3. **data** R data object for the current level.




## Add Within-level parameter matrices for each submodel

For each declared level `xxmWithinMatrix()` is used to add within-level parameter matrices. For each parameter matrix, the function adds the three matrices constructed earlier: 

 - **pattern** 
 - **value**
 - **label** (optional)
  


## Add Across-level parameter matrices to the model

Pairs of levels that share parent-child relationship have regression relationships. `xxmBetweenMatrix()` is used to add corresponding parameter matrices connecting the two levels. 

 - Level with the independent variable is the **parent** level. 
 - Level with the dependent variable is the **child** level.

For each parameter matrix, the function adds the three matrices constructed earlier: 

 - **pattern** 
 - **value**
 - **label** (optional)
 



## Estimate model parameters

Estimation process is initiated by `xxmRun()`. If all goes well, a quick printed summary of results is produced.




## Estimate profile-likelihood confidence intervals

Once parameters are estimated, confidence inetrvals are estimated by invoking `xxmCI()` . Depending on the the number of observations and the complexity of the dependence structure `xxmCI()` may take very long. `xxMCI()` displays a table of parameter estimates and CIS. 



## View results

A summary of results may be retrived as an R list by a call to `xxmSummary()`



## Free moodel object

`xxM` model object may hog a large amount of RAM outside of R's memory. This memory will automatically be released, when R's workspace is cleared by a call to `rm(list=ls())` or at the end of the R session. Alternatively, `xxmFree()` may be called to release memory.




[/su_tab] [/su_tabs]
