## @knitr load-library
library(xxm)
data(reisby.wide.xxm, package="xxm")

## @knitr construct-R-matrices
#Subject (Level-1) matrices
#Theta: Residual variances (constrained to equality)
theta_pattern <-diag(1,6)
theta_value <-diag(30,6)
theta_label <- diag(0, 6)
diag(theta_label) <- rep("theta",6)

#Psi: Latent growth factor covariance 
psi_pattern <- matrix(1,2,2)
psi_value <- diag(c(1,.1),2)
alpha_pattern <- matrix(1,2,1)
alpha_value <- matrix(c(23, -2),2,1)

#Lambda: Factor-loading matrix.
# Loading2 for the intercept factor (Column 1) fixed to 1.0
# Loading2 for the slope  factor (Column 2) fixed to 0.0 : 6.0
lambda_pattern <-matrix(0,6,2)
one <- rep(1.0,6)
week <- seq(from = 0, to = 5, by = 1)
lambda_value <-matrix(c(one, week),6,2)

## @knitr xxmModel 
# single level model
lgc <- xxmModel(levels = "subject") 

## @knitr xxmSubmodel 
lgc <- xxmSubmodel(model = lgc, 
                     level = "subject", 
                     parents = , 
                     ys = c("depression0","depression1","depression2", 
                            "depression3", "depression4","depression5" ), 
                     xs = , 
                     etas = c("Intercept", "Slope"), 
                     data = reisby.wide)

## @knitr xxmWithinMatrix
lgc <- xxmWithinMatrix(lgc,"subject","theta", theta_pattern, theta_value, theta_label)
lgc <- xxmWithinMatrix(lgc,"subject","psi", psi_pattern, psi_value)
lgc <- xxmWithinMatrix(lgc,"subject","alpha", alpha_pattern, alpha_value)
lgc <- xxmWithinMatrix(lgc, "subject","lambda", lambda_pattern, lambda_value)

## @knitr xxmRun
lgc <- xxmRun(lgc)

## @knitr xxmCI
lgc <- xxmCI(lgc)

## @knitr xxmSummary
xxmSummary(lgc)

## @knitr xxmFree
lgc<- xxmFree(lgc)


