library(xxm)
data(pcwa.xxm, package="xxm")
##########################
##########################

#   Model 1: simple random intercept

##########################
##########################
#   Model 2: Random slope
pcwa2 <- xxmModel(c("student","teacher"))
# 2.1 Model setup
pcwa2 <- xxmSubmodel(model = pcwa2, 
                       level = "student",
                       parents = "teacher", ys = "pc", 
                       xs = c("wa"),
                       etas = , data = pcwa.student)

pcwa2 <- xxmSubmodel(model = pcwa2, 
                       level = "teacher",
                       parents = , ys = , xs = , 
                       etas = c("int","slp"), 
                       data = pcwa.teacher)

# 2.2  Matrix specification
alpha_pattern <- matrix(1, 2,1)
alpha_value <- (matrix(c(443,1), 2,1))

psi_pattern <- matrix(1, 2,2)
psi_value <- (matrix(c(10,.0,.0,.05), 2,2))

lambda_pattern <- matrix(c(0,0), 1,2)
lambda_value <- (matrix(c(1,0), 1,2))
lambda_label <- (matrix(c("l11","student.wa"), 1,2))

theta_pattern <- matrix(1, 1,1)
theta_value <- (matrix(200., 1,1))
#Level 1: Student model
pcwa2 <- xxmWithinMatrix(model = pcwa2, level = "student",
                           type = "theta", pattern = theta_pattern, value = theta_value,,)
#Level 2: Teacher model
pcwa2 <- xxmWithinMatrix(model = pcwa2, level = "teacher",
                           type = "alpha", pattern = alpha_pattern, value = alpha_value,,)
pcwa2 <- xxmWithinMatrix(model = pcwa2, level = "teacher",
                           type = "psi", pattern = psi_pattern, value = psi_value,,)
#Teacher -> Student model
pcwa2 <- xxmBetweenMatrix(model = pcwa2, parent = "teacher",
                            child = "student", type = "lambda", pattern = lambda_pattern, 
                            value = lambda_value, label = lambda_label,)
# 2.3 Run model
pcwa2  <-xxmRun(pcwa2)
pcwa2 <- xxmCI(pcwa2)
est <- xxmGet(pcwa2,"estimates")
lik <- xxmGet(pcwa2,"fit")
est
lik
pcwa2  <-xxmFree(pcwa2)
rm(list=ls())
detach("package:xxm", unload=TRUE)
