## @knitr load-library
library(xxm)
data(faces.xxm,package="xxm") 
#Two observed responses at level 1: PA(physical attractiveness), SYM(symmetry)
#Level 1 responses are cross-classified within Rater(levek 2) and Target(level 3)
#faces.xxm contains 3 data frames: "response" (level1), rater (level2), target (level3)

## @knitr define-variables
#

## @knitr construct-R-matrices
## WITHIN-LEVEL MATRICES
# Model Matrices for Level 1 (response)
# Response: Observed residual covariance matrix
l1_theta_pat <- matrix(1,2,2)
l1_theta_val <- diag(3,2)
# Response: Observed variable intercepts
l1_nu_pat <- matrix(c(1,1),2,1)
l1_nu_val <- matrix(c(4.2671,5.2066),2,1)

#Model Matrices for Level 2 (rater)
# Rater: factor-covariance matrix
l2_psi_pat <- matrix(1,2,2)
l2_psi_val <- diag(.1,2)

#Model Matrices for Level 3 (target)
# Target: factor-covariance matrix
l3_psi_pat <- matrix(1,2,2)
l3_psi_val <- diag(.1,2)

## ACROSS-LEVEL MATRICES
# Rater -> Response factor-loading matrix
l1_l2_lambda_pat <- matrix(0,2,2)
l1_l2_lambda_val <- matrix(c(1,0,0,1),2,2)
# Target -> Response factor-loading matrix
l1_l3_lambda_pat <- matrix(0,2,2)
l1_l3_lambda_val <- matrix(c(1,0,0,1),2,2)
 
## @knitr xxmModel

xm <- xxmModel(levels = c("response", "rater", "target"))

## @knitr xxmSubmodel
#Level 1: Response submodel
xm <- xxmSubmodel(model = xm, level = "response", parents = c("rater", "target"),
                  ys = c("PA", "SYM"), xs =, etas =, data = faces.response, siblings =)
#Level 2: Rater submodel
xm <- xxmSubmodel(model = xm, level = "rater", parents =,
                  ys =, xs =, etas = c("eta1", "eta2"), data = faces.rater, siblings =)
#Level 3: Target submodel
xm <- xxmSubmodel(model = xm, level = "target", parents =,
                  ys =, xs =, etas = c("eta3", "eta4"), data = faces.target, siblings =)

## @knitr xxmWithinMatrix
## Level 1 (Response) within matrices (theta and nu)
xm <- xxmWithinMatrix(model = xm, level = "response", type = "theta",
                      pattern = l1_theta_pat, value = l1_theta_val, 
                      label = , name = )                       

xm <- xxmWithinMatrix(model = xm, level = "response", type = "nu",
                      pattern = l1_nu_pat, value = l1_nu_val, 
                      label = , name =  )                       
## Level 2 (Rater) within matrices (psi)
xm <- xxmWithinMatrix(model = xm, level = "rater", type = "psi",
                      pattern = l2_psi_pat, value = l2_psi_val, 
                      label = , name = )                       
## Level 3 (Target) within matrices (psi)
xm <- xxmWithinMatrix(model = xm, level = "target", type = "psi",
                      pattern = l3_psi_pat, value = l3_psi_val, 
                      label = , name = )                       


## @knitr xxmBetweenMatrix
# Rater -> Response factor-loading matrix
xm <- xxmBetweenMatrix(model = xm, parent = "rater", child = "response",
                       type = "lambda", pattern = l1_l2_lambda_pat, 
                       value = l1_l2_lambda_val, label = ,
                       name =  )
# Target -> Response factor-loading matrix
xm <- xxmBetweenMatrix(model = xm, parent = "target", child = "response",
                       type = "lambda", pattern = l1_l3_lambda_pat, 
                       value = l1_l3_lambda_val, label = ,
                       name =  )


## @knitr xxmRun
xm <-xxmRun(xm)
## @knitr xxmCI
xm <- xxmCI(xm)
## @knitr xxmSummary
s <- xxmSummary(xm)
s
## @knitr xxmFree
xxmFree(xm) 
rm(list=ls())
