


## Load xxM and data

```r
library(xxm)
data(hcfa.xxm, package = "xxm")
```

## Define local variables for conveinence 

```r
levels <- c("student", "teacher", "school")
# Level 1 variables:
id1 <- levels
ys1 <- c("y1", "y2", "y3")
etas1 <- c("A1")
l1parents <- c("teacher", "school")
# Level 2 variables:
id2 <- c("teacher", "school")
etas2 <- c("A2")
# Level 3 variables:
id3 <- c("school")
ys3 <- c("q1", "q2", "q3")
etas2 <- c("A3", "Q")
```


## Construct R-matrices  

For each parameter matrix, construct three related matrices:  

1. **pattern** matrix: A matrix indicating free or fixed parameters.
2. **value** matrix: with start or fixed values for corresponding parameters.
3. **label** matrix: with user friendly label for each parameter. **label** matrix is optional. 


```r
## STUDENT MODEL MATRICES (Within-model matrices) Student: factor-loading
## matrix
ly1_pat <- matrix(0, 3, 1)
ly1_val <- matrix(1, 3, 1)
## Student: factor-covariance matrix
ps1_pat <- matrix(1, 1, 1)
ps1_val <- matrix(0.1, 1, 1)
## Student: observed residual-covariance matrix
th1_pat <- diag(1, 3)
th1_val <- diag(2, 3)
## Student 'grand-means' NU
nu1_pat <- matrix(1, 3, 1)
nu1_val <- matrix(0, 3, 1)
## TEACHER MODEL MATRICES (Within-model matrices) Teacher: Latent covariance
## matrix
ps2_pat <- matrix(1, 1, 1)
ps2_val <- matrix(0.1, 1, 1)
## SCHOOL MODEL MATRICES (Within-model matrices) School: factor-loading
## matrix
ly3_pat <- matrix(0, 3, 2)
ly3_val <- matrix(c(0, 0, 0, 1, 1, 1), 3, 2)
## School: factor-covariance matrix
ps3_pat <- matrix(c(1, 0, 0, 1), 2, 2)
ps3_val <- matrix(c(0.1, 0, 0, 0.1), 2, 2)
## School: Observed covariance matrix
th3_pat <- diag(1, 3)
th3_val <- diag(2, 3)
## School: Observed intercepts
nu3_pat <- matrix(1, 3, 1)
nu3_val <- matrix(c(0.1, 0.1, 0.1), 3, 1)
## School: Latent Regression
be3_pat <- matrix(c(0, 0, 1, 0), 2, 2)
be3_val <- matrix(c(0, 0, 0.01, 0), 2, 2)
## TEACHER -> STUDENT (Across-model matrices) teacher - > Student: factor
## loading matrix
ly21_pat <- matrix(0, 3, 1)
ly21_val <- matrix(1, 3, 1)
## SCHOOL -> STUDENT (Across-model matrices) school - > Student: factor
## loading matrix
ly31_pat <- matrix(0, 3, 2)
ly31_val <- matrix(c(1, 1, 1, 0, 0, 0), 3, 2)
```


## Construct main model object  

`xxmModel()` is used to declare level names. The function returns a model object that is passed as a parameter to subsequent statements.


```r
xm <- xxmModel(levels = c("student", "teacher", "school"))
```

```
## A new model was created.
```


## Add submodels to the model objects

For each declared level `xxmSubmodel()` is invoked to add corresponding submodel to the model object. The function adds three pieces of information:
1. **parents** declares a list of parents of the current level.
2. **variables** declares names of observed dependent (**ys**), observed independent (**xs**) and latent variables (**etas**) for the level.
3. **data** R data object for the current level.


```r
### Submodel: Student
xm <- xxmSubmodel(model = xm, level = "student", parents = l1parents, ys = ys1, 
    xs = , etas = etas1, data = hcfa.student)
```

```
## Submodel for level `student` was created.
```

```r
### Submodel: Teacher
xm <- xxmSubmodel(model = xm, level = "teacher", parents = , ys = , xs = , etas = c("A2"), 
    data = hcfa.teacher)
```

```
## Submodel for level `teacher` was created.
```

```r
### Submodel: School
xm <- xxmSubmodel(model = xm, level = "school", parents = , ys = c("q1", "q2", 
    "q3"), xs = , etas = c("A3", "Q3"), data = hcfa.school)
```

```
## Submodel for level `school` was created.
```


## Add Within-level parameter matrices for each submodel

For each declared level `xxmWithinMatrix()` is used to add within-level parameter matrices. For each parameter matrix, the function adds the three matrices constructed earlier: 

 - **pattern** 
 - **value**
 - **label** (optional)
 
 

```r
## Student within matrices (lambda, psi, theta and nu)
xm <- xxmWithinMatrix(xm, "student", "lambda", ly1_pat, ly1_val)
```

```
## 
## 'lambda' matrix does not exist and will be added.
## 	Added `lambda` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "student", "psi", ps1_pat, ps1_val)
```

```
## 
## 'psi' matrix does not exist and will be added.
## 	Added `psi` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "student", "theta", th1_pat, th1_val)
```

```
## 
## 'theta' matrix does not exist and will be added.
## 	Added `theta` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "student", "nu", nu1_pat, nu1_val)
```

```
## 
## 'nu' matrix does not exist and will be added.
## 	Added `nu` matrix.
```

```r
## Teacher within matrices (psi)
xm <- xxmWithinMatrix(xm, "teacher", "psi", ps2_pat, ps2_val)
```

```
## 
## 'psi' matrix does not exist and will be added.
## 	Added `psi` matrix.
```

```r
## School within matrices (psi)
xm <- xxmWithinMatrix(xm, "school", "lambda", ly3_pat, ly3_val)
```

```
## 
## 'lambda' matrix does not exist and will be added.
## 	Added `lambda` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "school", "psi", ps3_pat, ps3_val)
```

```
## 
## 'psi' matrix does not exist and will be added.
## 	Added `psi` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "school", "theta", th3_pat, th3_val)
```

```
## 
## 'theta' matrix does not exist and will be added.
## 	Added `theta` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "school", "nu", nu3_pat, nu3_val)
```

```
## 
## 'nu' matrix does not exist and will be added.
## 	Added `nu` matrix.
```

```r
xm <- xxmWithinMatrix(xm, "school", "beta", be3_pat, be3_val)
```

```
## 
## 'beta' matrix does not exist and will be added.
## 	Added `beta` matrix.
```

## Add Across-level parameter matrices to the model

Pairs of levels that share parent-child relationship have regression relationships. `xxmBetweenMatrix()` is used to add corresponding parameter matrices connecting the two levels. 

 - Level with the independent variable is the **parent** level. 
 - Level with the dependent variable is the **child** level.

For each parameter matrix, the function adds the three matrices constructed earlier: 

 - **pattern** 
 - **value**
 - **label** (optional)
 

```r
## Teacher->Student lambda matrix
xm <- xxmBetweenMatrix(xm, "teacher", "student", "lambda", ly21_pat, ly21_val)
```

```
## 
## 'lambda' matrix does not exist and will be added.
## 	Added `lambda` matrix.
```

```r
## School->Student lambda matrix
xm <- xxmBetweenMatrix(xm, "school", "student", "lambda", ly31_pat, ly31_val)
```

```
## 
## 'lambda' matrix does not exist and will be added.
## 	Added `lambda` matrix.
```


## Estimate model parameters

Estimation process is initiated by `xxmRun()`. If all goes well, a quick printed summary of results is produced.


```r
xm <- xxmRun(xm)
```

```
## Model specification seems reasonable.
## Validity: Checked
## Matrix Constructed
## ------------------------------------------------------------------------------
## Estimating model parameters
## ------------------------------------------------------------------------------
##                7312.7727662923 
##                7284.2751352608 
##                7224.5094156590 
##                7217.0293959987 
##                7216.4627435112 
##                7209.9370976736 
##                7197.6664493211 
##                7192.7845233060 
##                7187.2617920830 
##                7183.6783050128 
##                7180.0783961659 
##                7174.2795022493 
##                7173.1599729664 
##                7167.6334977251 
##                7161.9509324448 
##                7160.9840671804 
##                7160.1653651317 
##                7156.6899161259 
##                7151.0178852780 
##                7146.6748152829 
##                7140.3937176077 
##                7134.3473857833 
##                7128.0524429519 
##                7119.5907202407 
##                7113.3533240998 
##                7112.8122665159 
##                7112.0235815798 
##                7110.9003093842 
##                7110.5913567621 
##                7110.5790125398 
##                7110.4612670267 
##                7110.4595101100 
##                7110.4594270626 
##                7110.4594251553 
##                7110.4594250673 
## Model converged normally
## ------------------------------------------------------------------------------
## *
##  1:                             student_theta_1_1 ::      1.727 [     0.000,      0.000]
## 
##  2:                             student_theta_2_2 ::      1.990 [     0.000,      0.000]
## 
##  3:                             student_theta_3_3 ::      1.854 [     0.000,      0.000]
## 
##  4:                               student_psi_1_1 ::      0.498 [     0.000,      0.000]
## 
##  5:                                student_nu_1_1 ::      0.526 [     0.000,      0.000]
## 
##  6:                                student_nu_2_1 ::      0.571 [     0.000,      0.000]
## 
##  7:                                student_nu_3_1 ::      0.592 [     0.000,      0.000]
## 
##  8:                               teacher_psi_1_1 ::      0.334 [     0.000,      0.000]
## 
##  9:                              school_theta_1_1 ::      0.787 [     0.000,      0.000]
## 
## 10:                              school_theta_2_2 ::      0.937 [     0.000,      0.000]
## 
## 11:                              school_theta_3_3 ::      1.418 [     0.000,      0.000]
## 
## 12:                                school_psi_1_1 ::      0.355 [     0.000,      0.000]
## 
## 13:                                school_psi_2_2 ::      0.402 [     0.000,      0.000]
## 
## 14:                                 school_nu_1_1 ::      0.129 [     0.000,      0.000]
## 
## 15:                                 school_nu_2_1 ::      0.144 [     0.000,      0.000]
## 
## 16:                                 school_nu_3_1 ::      0.081 [     0.000,      0.000]
## 
## 17:                               school_beta_1_2 ::      0.882 [     0.000,      0.000]
## 
## ------------------------------------------------------------------------------
```


## Estimate profile-likelihood confidence intervals

Once parameters are estimated, confidence inetrvals are estimated by invoking `xxmCI()` . Depending on the the number of observations and the complexity of the dependence structure `xxmCI()` may take very long. `xxMCI()` displays a table of parameter estimates and CIS. 



## View results

A summary of results may be retrived as an R list by a call to `xxmSummary()`

```r
s <- xxmSummary(xm)
```


## Free moodel object

`xxM` model object may hog a large amount of RAM outside of R's memory. This memory will automatically be released, when R's workspace is cleared by a call to `rm(list=ls())` or at the end of the R session. Alternatively, `xxmFree()` may be called to release memory.


```r
xxmFree(xm)
```

```
##          used (Mb) gc trigger (Mb) max used (Mb)
## Ncells 259244  7.0     407500 10.9   350000  9.4
## Vcells 234055  1.8     786432  6.0   786318  6.0
```

```r
rm(list = ls())
```

