\name{hcfa.xxm.3}
\alias{hcfa}
\title{
xxM Model Example: hcfa.xxm.3.R
}
\section{Introduction: Hierarchical Confirmatory Factor Analysis}{
\bold{hcfa} is a three level hierarchical SEM model with observed dependent variables at levels 1 and 3; and latent variables at all three levels. The model includes a latent variable regression at level 3.  The data for this model were simulated. The example is intended to illustrate different within- and between- parameter matrices.

Unlike the previous two models, level-2 and level-3 latent variables are not directly defined by level-1 observed variables. Instead, these variables are defined as "random-intercepts" for level-1 and level-2 latent variables, respectively. Alternatively, the model can also be thought of as a SEM Hierarchical-Factor model of sorts.

Form a practical standpoint there are two differences between the current model and the previous two models:
\enumerate{
\item \bold{student} now has a single `parent` \bold{teacher}, and \bold{school} is now a `parent` of \bold{teacher} rather than \bold{school}. This involves changes to the \code{xxmSubmodel()} statements for \bold{student} and \bold{teacher}.  
\item Random-intercept for a latent variables involve across-level regression among latent variables. This model involves across-level latent variable regression. Hence, across-level relationships are defined using \bold{beta} matrices instead of \bold{lambda} matrices.
}
}

\section{Creating a model: `hcfa`}{
The model involves three levels: \bold{student}, \bold{teacher}, \bold{school} 
\enumerate{
  \item \bold{student} is nested within \bold{teacher} but not \bold{school}. \bold{student} has a three observed dependent variables: \bold{y1}, \bold{y2}, and \bold{y3}; and a single latent variable \bold{A1}.
  
  \item \bold{teacher} is a \bold{parent} of \bold{student} and is itself nested within \bold{school}. \bold{teacher} has no observed variable and a single latent variable: \bold{A2} defined by \bold{A1} at the \bold{student} level. 
  
  \item \bold{school} is a \bold{parent} of \bold{teacher}. \bold{school} includes three observed dependent variables: \bold{q1}, \bold{q2}, and \bold{q3}. \bold{school} submodel has two latent variables: \bold{A3}  defined by latent variable \bold{A2} at the \bold{teacher} level and a school level latent variable \bold{Q} defined by level-3 observed variables. 
}
\bold{hcfa} is created by invoking \code{xxmModel()}.

\preformatted{hcfa <- xxmModel(levels = c("student","teacher","school"))}

Note: Levels are numbered according to their position in the above command.  Hence, \bold{student} corresponds to level 1, \bold{teacher} corresponds to level 2, and \bold{school} corresponds to level 3. 
}

\section{Adding submodels for `student`, `teacher` and `school`}{
For each level declared above, we need to create corresponding submodels. A submodel is created by invoking \code{xxmSubmodel()}: 
\enumerate{
\item \bold{student}

\preformatted{
hcfa <- xxmSubmodel(model = hcfa, level = "student",
 parents = c("teacher"), ys = ys1, xs =, 
 etas = c("A1"), data = hcfa.student)}
                  
\item \bold{teacher}

\preformatted{
teacher <- xxmSubmodel(model = hcfa, level="teacher", 
  parents = c("school"), ys =, xs =, etas = c("A2"), data = hcfa.teacher)}

\item \bold{school}

\preformatted{
hcfa <-  xxmSubmodel(model = hcfa,level = "school", parents =, 
 ys = c("q1","q2","q3"), xs =, etas = c("A3", "Q3"), 
 data = hcfa.school)}
}
}

\section{Specifying within-level model matrices for `student` (level 1) }{
\bold{student} model involves a factor-model with all three level-1 observed variables loading on a single latent variable \bold{A1}. Factor model involves three parameter matrices: factor-loading matrix \bold{lambda}, latent factor covariance matrix \bold{psi}, and observed residual-covariance matrix \bold{theta}. With raw data, we also need to specify measurement intercepts for observed variables using \bold{nu}. 

\enumerate{

 \item \bold{lambda}: Factor loading matrix is a (3x1) matrix. The first factor loading is fixed to 1.0 and the remaining two are frely estimated.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "student", 
 type = "lambda", pattern = ly1_pat, value = ly1_val)}

 \item \bold{psi}: Latent covariance matrix is a (1x1) matrix with freely estimated variance of the latent variable \bold{A1}.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level ="student", 
  type = "psi", pattern = ps1_pat, value = ps1_val)}

\item \bold{theta}: Observed residual-covariance matrix is a (3x3) matrix with all three residual variances (diagonal elements) freely estimated.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "student", 
  type = "theta", pattern = th1_pat, value = th1_val)}
 
  \item \bold{nu}: Observed variable intercept matrix is a (3x1) matrix with freely estimated intercepts.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "student", 
  type  ="nu", pattern = nu1_pat, value = nu1_val) }
}
}

\section{Specifying within level model matrices for `teacher`  (level 2) }{
With a single latent variable \bold{A2}, the submodel for \bold{teacher} is simple. It includes a single variance of the latent dependent variable.
\enumerate{
\item \bold{psi}: Latent covariance matrix is a (1x1) matrix with a single element, the variance of the latent variable \bold{A2}.

\preformatted{
hcfa <- xxmWithinMatrix(model = hcfa, level = "teacher", 
 type = "psi", pattern = ps2_pat, value = ps2_val)}
}
}

\section{Specifying within-level model matrices for `school`  (level 3) }{
\bold{school} has two latent variables \bold{A3} and \bold{Q}. 

\bold{Q} is defined by all  level-3 observed indicators. As in case of level-1 we need to define a measurement model for \bold{Q}. Measurement model involves three parameter matrices: factor-loading matrix \bold{lambda}, latent factor covariance matrix \bold{psi}, and observed residual-covariance matrix \bold{theta}. With raw data, we also need to specify measurement intercepts for observed variables using \bold{nu}. 

\bold{A3} is regressed on \bold{Q}.  The latent regression matrix is called \bold{beta}. 

\enumerate{

\item \bold{lambda}: Factor loading matrix is a (3x2) matrix. The first latent variable \bold{A3} is defined by level-1 indicators. Hence the first column is fixed to 0.0. The second latent variable \bold{Q}. The first row of the second column is fixed to 1.0 to define the latent variable scale. The last two elements of second column are freely estimated.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "school", 
  type = "lambda", pattern = ly3_pat, value = ly3_val)}

\item \bold{psi}: Latent covariance matrix is a (2x2) diagonal matrix. The first element is the residual variance of the latent dependent variable \bold{A3} and the second element is the unconditional variance of the latent predictor \bold{Q}. 

\preformatted{
hcfa <- xxmWithinMatrix(mdoel = hcfa, level = "school", 
 type = "psi", pattern = ps2_pat, value = ps2_val)}

\item \bold{theta}: Observed residual-covariance matrix is a (3x3) matrix with all three residual variances (diagonal elements) freely estimated.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "school", 
  type = "theta", pattern = th3_pat, value = th3_val)}
 
  \item \bold{nu}: Observed variable intercept matrix is a (3x1) matrix with freely estimated intercepts.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "school", 
  type  ="nu", pattern = nu3_pat, value = nu3_val) }

 
  \item \bold{beta}: Latent variable rergession matrix is a (2x2) upper-triangular matrix with a single free element \eqn{\beta_{1,2}}.

 \preformatted{
 hcfa <- xxmWithinMatrix(model = hcfa, level = "school", 
  type  = "beta", pattern = be3_pat, value = be3_val) }

}
}
\section{Specifying across-level model matrices connecting `teacher` and `student`}{So far, we have specified within-level matrices.  We now need to connect observed and latent variables across-levels. For this models, latent variables at level-2 and level-3 are measured by level-1 latent variable \bold{A1}. Such across-level structural relationship is specified with a \bold{beta} matrix.  All across-level matrices connecting variables across two submodels are specified by invoking \code{xxmBetweenMatrix()}. 

\enumerate{
\item \bold{beta}: Latent variable regression matrix is a (1x1) matrix. The single element is fixed to 1.0 suggesting that the level-2 latent variable \bold{A2} is a random-intercept for the level-1 latent variable \bold{A1}. 

\preformatted{
hcfa <- xxmBetweenMatrix(model = hcfa, parent = "teacher", child = "student",
type = "beta", pattern = be12_pat, value = be12_val)}
}
}

\section{Specifying across-level model matrices connecting `school` and `teacher`}{
The first latent variable at leve-3 \bold{A3} is measured by level-2 latent variable \bold{A2}. 

\enumerate{
 \item \bold{beta}: Factor-loading matrix is a (1x2) matrix.  The first latent variable \bold{A3} is defined by level-2 latent variable \bold{A2} and is fixed to 1.0.  The The second latent variable \bold{Q} was already defined by level-3 observed variables. Hence the second element is fixed to 0.0. 

 \preformatted{
 hcfa <- xxmBetweenMatrix(model = hcfa, parent = "school", 
  child = "teacher", type = "beta", pattern = be23_pat, 
  value = be23_val)}
}
}
}
\section{Compute: \bold{xxmRun()}}{
Model specification is now complete. Parameter estimation is initiated as follows:
\preformatted{hcfa <-xxmRun(model = hcfa)}
}

\section{Notes}{
\enumerate{
\item Dataset for this model is packaged with \code{xxm} in an R workspace called \code{hcfa.xxm.RData}. The three data frames called `hcfa.student`, 'hcfa.teacher`, and 'hcfa,school` are loaded into the R workspace when the library is loaded: 

\code{library(xxm)}

\code{data(hcfa.xxm, package="xxm")}

\item Datasets for this model are documented under \code{hcfa.xxm.RData} in ???.

\item R script for running this model is stored under \code{.../models/hcfa.3.xxm.R}
}

}
