library(xxm)
#Conditional Rater-target model, ignoring rater and target gender
#Two observed responses at level 2: PA(physical attractiveness), SYM(symmetry)
#Level 1 responses are cross-classified within Rater(l2a) and Target(l2b)

#faces.xxm contains 3 data frames: "response" (level1), rater (level2a), target (level2b)
data(faces.xxm,package="xxm") 


#### MODEL MATRICES ####
#Model Matrices for Level 2a (rater)
l2a_psi_pat <- matrix(c(1,0,0,1),2,2)
l2a_psi_val <- matrix(c(.1,0,0,.1),2,2)
#l2a_psi_lab <- matrix(c("Rater_PA_Res_Var","p1","p1","Rater_SYM_Var"),2,2)

l2a_beta_pat <- matrix(c(0,0,1,0),2,2)
l2a_beta_val <- matrix(c(0,0,.00,0),2,2)
#l2a_beta_lab <- matrix(c("p3","p4","Rater PA on SYM","p5"),2,2)

#Model Matrices for Level 2b (target)
l2b_psi_pat <- matrix(c(1,0,0,1),2,2)
l2b_psi_val <- matrix(c(.1,0,0,.1),2,2)
#l2b_psi_lab <- matrix(c("Target_PA_Res_Var","p6","p6","Target_SYM_Var"),2,2)

l2b_beta_pat <- matrix(c(0,0,1,0),2,2)
l2b_beta_val <- matrix(c(0,0,.0,0),2,2)
#l2b_beta_lab <- matrix(c("p8","p9","Target PA on SYM","p10"),2,2)

#Model Matrices for Level 1
l1_theta_pat <- matrix(c(1,1,1,1),2,2)
l1_theta_val <- matrix(c(2,.0,.0,2),2,2)
#l1_theta_lab <- matrix(c("PA_Res_Var","PA_SYM_Res_Cov","PA_SYM_Res_Cov","SYM_Res_Var"),2,2)

l1_nu_pat <- matrix(c(1,1),2,1)
l1_nu_val <- matrix(c(5,5),2,1)
#l1_nu_lab <- matrix(c("PA_Int","SYM_Int"),2,1)

#Model Matrices for Between
l2a_lambdaBTW_pat <- matrix(c(0,0,0,0),2,2)
l2a_lambdaBTW_val <- matrix(c(1,0,0,1),2,2)
#l2a_lambdaBTW_lab <- matrix(c("Eta1_PA_Rater","p11","p12","Eta2_SYM_Rater"),2,2)

l2b_lambdaBTW_pat <- matrix(c(0,0,0,0),2,2)
l2b_lambdaBTW_val <- matrix(c(1,0,0,1),2,2)
#l2b_lambdaBTW_lab <- matrix(c("Eta1_PA_Target","p13","p14","Eta2_SYM_Target"),2,2)


#Step 1: Create model and define level names
xm <- xxmModel(levels = c("response", "rater", "target"))

#Step 2: Create submodels for each level declared in xxmModel()
#Level 2a (rater) submodel
xm <- xxmSubmodel(model = xm, level = "rater", parents =,
                  ys =, xs =, etas = c("eta1", "eta2"), data = faces.rater, siblings =)
#Level 2b (target) submodel
xm <- xxmSubmodel(model = xm, level = "target", parents =,
                  ys =, xs =, etas = c("eta3", "eta4"), data = faces.target, siblings =)
#Level 1 (response) submodel
xm <- xxmSubmodel(model = xm, level = "response", parents = c("rater", "target"),
                  ys = c("PA", "SYM"), xs =, etas =, data = faces.response, siblings =)

#Step 3A: Add within-matrices to submodels
#l1 within matrices (lambda, psi and theta)
xm <- xxmWithinMatrix(model = xm, level = "response", type = "theta",
                      pattern = l1_theta_pat, value = l1_theta_val, 
                      label = , name ="l1_theta")                       

xm <- xxmWithinMatrix(model = xm, level = "response", type = "nu",
                      pattern = l1_nu_pat, value = l1_nu_val, 
                      label = , name = "l1_nu")                       
#l2 within matrices (psi, lambda)
xm <- xxmWithinMatrix(model = xm, level = "rater", type = "psi",
                      pattern = l2a_psi_pat, value = l2a_psi_val, 
                      label = , name ="l2a_psi")                       

xm <- xxmWithinMatrix(model = xm, level = "rater", type = "beta",
                      pattern = l2a_beta_pat, value = l2a_beta_val, 
                      label = , name = "l2a_beta")                       

xm <- xxmWithinMatrix(model = xm, level = "target", type = "psi",
                      pattern = l2b_psi_pat, value = l2b_psi_val, 
                      label = , name ="l2b_psi")                       
xm <- xxmWithinMatrix(model = xm, level = "target", type = "beta",
                      pattern = l2b_beta_pat, value = l2b_beta_val, 
                      label = , name = "l2b_beta")                       

#Step 3B: Add between-matrices connecting submodels
##l2a->l1 (rater) lambda matrix 
xm <- xxmBetweenMatrix(model = xm, parent = "rater", child = "response",
                       type = "lambda", pattern = l2a_lambdaBTW_pat, 
                       value = l2a_lambdaBTW_val, label = ,
                       name = "l2a_lambdaBTW")

##l2b->l1 (target) lambda matrix 
xm <- xxmBetweenMatrix(model = xm, parent = "target", child = "response",
                       type = "lambda", pattern = l2b_lambdaBTW_pat, 
                       value = l2b_lambdaBTW_val, label = ,
                       name = "l2b_lambdaBTW")

#Step 4: Compute
xx <-xxmRun(xm) 

#Step 4: Clean-up
xxmFree(xm) 
rm(list=ls())
detach("package:xxm", unload=TRUE)
