## @knitr load-library
library(xxm)
data(brim.xxm, package="xxm")

## @knitr construct-R-matrices
theta_pattern <- matrix(c(1,1,1,1), nrow = 2,ncol = 2)
theta_value <- matrix(c(1,.0,.0,1), nrow = 2,ncol = 2)
alpha_pattern <- matrix(1,2,1)
alpha_value <- matrix(c(0.0 ,0.0),2,1)
psi_pattern <- matrix(c(1,1,1,1), ,2,2)
psi_value <- matrix(c(.1,.0,.0,.1),2,2)
lambda_pattern <- matrix(c(0,0,0,0),2,2)
lambda_value <- matrix(c(1,0.0,0.0,1),2,2)

## @knitr xxmModel 
xm <- xxmModel(levels = c("student","teacher")) 

## @knitr xxmSubmodel

### Submodel: Student
xm <- xxmSubmodel(model = xm, level = "student", parents = c("teacher"), 
                  ys = c("y1","y2"), xs =, etas =, data = brim.student) 
### Submodel: Teacher
xm <- xxmSubmodel(model = xm, leve = "teacher", parents = , ys =, xs =, 
                  etas = c("eta1","eta2"), data = brim.teacher)

## @knitr xxmWithinMatrix

### Within-Matrix: Level :: Student, Type :: observed residual-covariance
xm <- xxmWithinMatrix(model = xm, level= "student", type = "theta", 
                      pattern = theta_pattern, value = theta_value)

### Within-Matrix: Level :: Teacher, Type :: latent means
xm <- xxmWithinMatrix(model = xm, level = "teacher", type = "alpha", 
                      pattern = alpha_pattern, value = alpha_value) 

### Within-Matrix: Level :: Teacher, Type :: latent residual covariance
xm <- xxmWithinMatrix(model = xm, level = "teacher", type = "psi", pattern = psi_pattern, 
                      value = psi_value) 

## @knitr xxmBetweenMatrix

### Between-Matrix: Parent :: Teacher, Child :: Student, Type :: factor-loadings
xm <- xxmBetweenMatrix(model = xm, parent = "teacher", child = "student",
                       type = "lambda", pattern = lambda_pattern, value = lambda_value)

## @knitr xxmRun 
xm <- xxmRun(xm)

## @knitr xxmCI
xm <- xxmCI(xm)

## @knitr xxmSummary 
s <- xxmSummary(xm)
s

## @knitr xxmFree
xm <- xxmFree(xm)