library(xxm) 
data(hcfa.xxm,package="xxm")
levels <- c("student", "teacher", "school")
#Level 1 variables:
id1 <-  levels
ys1  <- c("y1", "y2", "y3")
etas1 <- c("A1")
l1parents <-c("teacher","school")
#Level 2 variables:
id2 <-  c("teacher","school")
etas2 <- c("A2")
#Level 3 variables:
id3 <-  c("school")
ys3 <- c("q1","q2","q3")
etas2 <- c("A3","Q")
 
################################################################## 
########################## STUDENT MODEL MATRICES ################
#Student: factor-loading matrix 
ly1_pat <-  matrix(c(1,1,1),3,1)
ly1_val <-  matrix(c(.1,.1,.1),3,1) 
ly1_lab <-  matrix(c("ly1","ly2","ly3"),3,1) 

#Student: factor-covariance matrix 
ps1_pat <- matrix(0,1,1)
ps1_val <- matrix(1,1,1)

#Student: observed residual-covariance matrix   
th1_pat <- diag(1,3)
th1_val <- diag(3,3)

#Student "grand-means" NU 
nu1_pat <- matrix(1,3,1)
nu1_val <- matrix(.1,3,1)
################################################################## 
###################### Teacher model matrices ############
#ps
ps2_pat <- matrix(0,1,1)
ps2_val <- matrix(1,1,1)
################################################################## 
###################### School model matrices ############
ly3_pat <- matrix(c(0,0,0,0,1,1),3,2)
ly3_val <- matrix(c(0,0,0, 1,1,1),3,2)

ps3_pat <- matrix(c(1,0,0,1),2,2)
ps3_val <- matrix(c(.01,0,0,.01),2,2)

th3_pat <- diag(1,3)
th3_val <- diag(2,3)

nu3_pat <- matrix(1,3,1)
nu3_val <- matrix(0,3,1)

be3_pat <- matrix(c(0,0,1,0),2,2)
be3_val <- matrix(c(0,0,.01,0),2,2)
################################################################## 
###################### teacher - > Student matrices ############
be12_pat <- matrix(1,1,1) 
be12_val <- matrix(0,1,1)
################################################################## 
###################### school - > teacher matrices ############
be13_pat <- matrix(0,1,2) 
be13_val <- matrix(c(1,0),1,2) 
#xxm Script
xm <- xxmModel(levels = c("student", "teacher", "school"))
xm <- xxmModel(levels = c("student", "teacher", "school"))
xm <- xxmSubmodel(model = xm, level = "student", parents = l1parents, 
                  ys = ys1, xs =, etas=etas1, data = hcfa.student)
xm <- xxmSubmodel(model = xm, level="teacher", parents = "school", ys =, xs =, 
                  etas = c("A2"), data = hcfa.teacher)
xm <- xxmSubmodel(model = xm,level = "school",parents =, 
                  ys = c("q1","q2","q3"), xs =, etas = c("A3", "Q3"), data = hcfa.school)
## ##################################################################
## Student within matrices (lambda, psi, theta and nu)
xm <- xxmWithinMatrix(xm,"student","lambda", ly1_pat, ly1_val)
xm <- xxmWithinMatrix(xm,"student","psi", ps1_pat, ps1_val)
xm <- xxmWithinMatrix(xm,"student","theta", th1_pat, th1_val)
xm <- xxmWithinMatrix(xm,"student","nu", nu1_pat, nu1_val) 
## Teacher within matrices (psi)
xm <- xxmWithinMatrix(xm,"teacher","psi", ps2_pat, ps2_val)
## School within matrices (psi)
xm <- xxmWithinMatrix(xm,"school","lambda", ly3_pat, ly3_val)
xm <- xxmWithinMatrix(xm,"school","psi", ps3_pat, ps3_val)
xm <- xxmWithinMatrix(xm,"school","theta", th3_pat, th3_val)
xm <- xxmWithinMatrix(xm,"school","nu", nu3_pat, nu3_val) 
xm <- xxmWithinMatrix(xm,"school","beta", be3_pat, be3_val) 
## Teacher->Student beta matrix 
xm <- xxmBetweenMatrix(xm,"teacher","student","beta", be12_pat, be12_val)
## School->teacher beta matrix 
xm <- xxmBetweenMatrix(xm,"school","teacher","beta", be13_pat, be13_val)
xm <-xxmRun(xm)
xm <- xxmCI(xm)
est <- xxmGet(xm,"estimates")
lik <- xxmGet(xm,"fit")
est
lik
xxmFree(xm) 
rm(list=ls())
detach("package:xxm", unload=TRUE)
